<?php
/**
 * iShare 1.2
 * Copyright  2011 Simon S., All Rights Reserved
 */
 
// Disallow direct access to this file for security reasons
if(!defined("IN_MYBB"))
{
	die("Direct initialization of this file is not allowed.<br /><br />Please make sure IN_MYBB is defined.");
}

$plugins->add_hook('admin_config_action_handler','ishare_admin_action');
$plugins->add_hook('admin_config_menu','ishare_admin_menu');
$plugins->add_hook('showthread_start','ishare_get_buttons');
$plugins->add_hook('misc_start','ishare_buttons_popup');
$plugins->add_hook('admin_user_groups_edit_graph_tabs', 'ishare_admin_groups_edit');
$plugins->add_hook('admin_user_groups_edit_commit', 'ishare_admin_groups_edit_commit');
$plugins->add_hook("admin_config_settings_change", "ishare_settings");
$plugins->add_hook("admin_config_settings_start", "ishare_settings");

function ishare_info()
{
	 global $lang;

	 $lang->load("ishare");
	 
	 return array(
		"name"			=> $lang->plugin_title,
		"description"	=> $lang->plugin_desc,
		"website"		=> "http://market.codicious.com/view/wysiwyg",
		"author"		=> "Codicious",
		"authorsite"	=> "http://codicious.com/",
		"version"		=> "1.2.1",
		"guid" 			=> "e9353891c38fe091f7c8aff65d5e41de",
		"compatibility" => "16*"
	 );
}
 
 
function ishare_install() 
{
     global $mybb, $db, $cache;

	 include_once MYBB_ROOT."inc/class_xml.php";
	 
	 $query = "CREATE TABLE IF NOT EXISTS `".TABLE_PREFIX."sharebuttons` (
       `bid` int(11) NOT NULL AUTO_INCREMENT,
       `name` varchar(120) NOT NULL DEFAULT '',
       `url` varchar(200) NOT NULL DEFAULT '',
       `icon` varchar(120) NOT NULL DEFAULT '',
       `popup` int(1) NOT NULL DEFAULT '0',
       `popupwidth` int(6) NOT NULL DEFAULT '250',
       `popupheight` int(6) NOT NULL DEFAULT '300',
       `disporder` int(11) NOT NULL DEFAULT '1',
       `active` int(1) NOT NULL DEFAULT '1',
        PRIMARY KEY (`bid`)
      ) CHARSET=utf8 AUTO_INCREMENT=20 ;";
   
      $db->query($query);  
	  
      $contents = @file_get_contents(MYBB_ROOT.'inc/plugins/ishare/buttons.xml');

      $parser = new XMLParser($contents);
      $tree = $parser->get_tree();

	  foreach ($tree['buttons']['button'] AS $button) 
	  {
	      $query = array(
		      "name" => $button['name']['value'],
		      "url" => $button['url']['value'],
		      "icon" => $button['icon']['value'],
		      "popup" => $button['popup']['value'],
		      "popupwidth" => $button['popupwidth']['value'],
		      "popupheight" => $button['popupheight']['value'],
		      "disporder" => $button['disporder']['value'],
		      "active" => "1"
		  );
	
	      $db->insert_query("sharebuttons", $query);
	  }
	  
      $db->write_query("DELETE FROM ".TABLE_PREFIX."settings WHERE name IN(
		'buttonsperrow',
		'sharebuttonlimit',
		'ishareupdatecheck'
	  )");
	  
	  $query = $db->query("SELECT disporder FROM ".TABLE_PREFIX."settinggroups ORDER BY disporder DESC LIMIT 1");
      $disporder = ($db->fetch_field($query, "disporder"))+1;
 
      $insertarray = array(
	    'name' => 'ishare',
	    'title' => 'iShare',
		'description' => 'Here you can change how iShare should display the buttons.',
		'isdefault' => '0',
	    'disporder' => $disporder
	  );
	
      $gid = $db->insert_query("settinggroups", $insertarray);  
   
      /* $insertarray = array(
	       'name' => 'ishareupdatecheck',
	       'title' => 'Search Automatically For Updates?',
		   'description' => 'If yes, ishare will search automatically for new updates and will notify you.',
		   'optionscode' => 'yesno',
		   'value' => '1',
	       'disporder' => '1',
		   'gid' => $rows+1
	   ); */
	
      $db->insert_query("settings", $insertarray);  
	  
      $insertarray = array(
	       'name' => 'buttonsperrow',
	       'title' => 'Buttons per row',
		   'description' => 'Here you can type in a number, how many buttons should be show per row in the share box.',
		   'optionscode' => 'text',
		   'value' => '8',
	       'disporder' => '2',
		   'gid' => $gid
	   );
	
      $db->insert_query("settings", $insertarray); 
	  
      $insertarray = array(
	       'name' => 'sharebuttonlimit',
	       'title' => 'Maximal Number Of Buttons',
		   'description' => 'If yes, ishare will search automatically for new updates and will notify you.',
		   'optionscode' => 'text',
		   'value' => '8',
	       'disporder' => '3',
		   'gid' => $gid
	   );
	
      $db->insert_query("settings", $insertarray); 
	  
	  rebuild_settings();
	  
	  $db->write_query("ALTER TABLE `".TABLE_PREFIX."usergroups` ADD `cansharethreads` int(1) NOT NULL default '1'");
	  
	  $cache->update_usergroups();
}

function ishare_activate() 
{
      global $db, $mybb;

	  include MYBB_ROOT."/inc/adminfunctions_templates.php";
	  include_once MYBB_ROOT."inc/class_xml.php";
	  
 	  $new = '{$sharebuttons}
	{$quickreply}';
   
      find_replace_templatesets("showthread", "#".preg_quote('{$quickreply}')."#i", $new);

      $contents = @file_get_contents(MYBB_ROOT.'inc/plugins/ishare/templates.xml');

      $parser = new XMLParser($contents);
      $tree = $parser->get_tree();

	  foreach ($tree['templates']['template'] AS $template) 
	  {
	      $insert_array = array(
		    'title' => $template['title']['value'],
		    'template' => $db->escape_string($template['template']['value']),
		    'sid' => '-1',
		    'version' => '',
		    'dateline' => TIME_NOW
	       );
	
	      $db->insert_query("templates", $insert_array);
	  }
}

function ishare_uninstall()
{
      global $mybb, $db, $cache;
	  
	  $db->query("drop table if exists ".TABLE_PREFIX."sharebuttons");
	  
	  $db->write_query("DELETE FROM ".TABLE_PREFIX."settinggroups WHERE name IN(
		'ishare'
	   )");	  
	   
	  $db->write_query("DELETE FROM ".TABLE_PREFIX."settings WHERE name IN(
		'buttonsperrow',
		'sharebuttonlimit'
	   )");
	
      rebuild_settings();
	  
	  $db->write_query("ALTER TABLE `".TABLE_PREFIX."usergroups` DROP `cansharethreads`");

      $cache->update_usergroups();	  
}

function ishare_deactivate() 
{
      global $mybb, $db;

	  include MYBB_ROOT."/inc/adminfunctions_templates.php";
	  include MYBB_ROOT."inc/class_xml.php";
	  
 	  $old = '{$sharebuttons}
	{$quickreply}';
   
      find_replace_templatesets("showthread", "#".preg_quote($old)."#i", '{$quickreply}', 0);
	  
	  $contents = @file_get_contents(MYBB_ROOT.'inc/plugins/ishare/templates.xml');

      $parser = new XMLParser($contents);
      $tree = $parser->get_tree();

	  foreach ($tree['templates']['template'] AS $template) 
	  {
	      $db->delete_query("templates", "title = '".$template['title']['value']."'");
	  }
}

function ishare_is_installed()
{
    global $db;
	
	if($db->table_exists("sharebuttons"))
	{	
	    return true;	
	}

	return false;
}
 
function ishare_get_buttons () 
{
      global $mybb, $thread, $templates, $sharebuttons, $theme, $db, $collapsed, $collapsedimg, $lang;

	  $lang->load("ishare");
	  
	  if($mybb->usergroup['cansharethreads'] == 1)
	  {  
	      $query = $db->simple_select("sharebuttons", "*", "active = '1'", array("order_by" => 'disporder, name', "order_dir" => 'ASC', "limit" => 10));
	  
	      $trow = 2;
	  
	      while($button = $db->fetch_array($query))
	      {
	           $i++;
		   
		       if($i == 1)
		       {
		           eval("\$buttons .= \"".$templates->get("showthread_sharebuttons_tr_start")."\";");
			   
			       $trow = 2;
		       }
		   
		       if($trow == 1)
		       {
		           $trow = 2;
		       }	
		       else
		       {
		           $trow = 1;
		       }    

		       $thread_URL = $mybb->settings['bburl']."/showthread.php?tid={$thread['tid']}";
		       $thread_URL = urlencode($thread_URL);
		       $thread_subject = $thread['subject'];
			   $thread_subject = urlencode($thread_subject);
		   
		       $button['url'] = str_replace('{URL}', $thread_URL, $button['url']);
		       $button['url'] = str_replace('{TITLE}', $thread_subject, $button['url']);
		   
		       $button['link'] = $button['url'];
		       $button['popuplink'] = '';
		       $button['target'] = '_blank';
		   
               if($button['popup'] == 1)
               {
                   $button['popuplink'] = "MyBB.popupWindow('{$button['url']}', 'bsharethread', {$button['popupwidth']}, {$button['popupheight']});";
			       $button['link'] = "#";
		           $button['target'] = '';
               }		   
		   
		       eval("\$buttons .= \"".$templates->get("showthread_sharebuttons_button")."\";");	
		   
		       if($i == $mybb->settings['buttonsperrow'])
		       {
			       eval("\$buttons .= \"".$templates->get("showthread_sharebuttons_tr_end")."\";");
			   
		    	   $i = 0;
		    	   $tr = 1;
		       }	  	   
	      }
	  
	      if($i !== 0 && $tr == 1)
	      {	  
		      for ($i = $i; ; $i++)
		      {
		          if($trow == 1)
		          {
		              $trow = 2;
		          }	
		          else
		          {
		              $trow = 1;
		          }		  
		  
			      if($i == $mybb->settings['buttonsperrow']) 
			      {
		              break;
		          }	
				  
			      eval("\$buttons .= \"".$templates->get("showthread_sharebuttons_emptyrow")."\";");	
		      }
	      }
		  
		  if($mybb->usergroup['cansharethreads'] == "1")
		  {
              eval("\$sharebuttons = \"".$templates->get("showthread_sharebuttons")."\";");		
          }			  
	  }
}

function ishare_buttons_popup()
{
    global $mybb;
	
	if($mybb->input['action'] == "sharebuttonspopup" && trim($mybb->input['tid']))
    {
		  if($mybb->usergroup['cansharethreads'] == "1")
		  {
		  
		      global $db, $templates, $lang, $headerinclude, $theme;
			  
			  $lang->load('ishare');

	          $buttonsperrow = 3;
	          $trow = 2;
			  
			  $query = $db->simple_select("threads", "subject, tid", "tid = '".$mybb->input['tid']."'", array("limit" => 1));		  
			  $thread = $db->fetch_array($query);
			  
			  $query = $db->simple_select("sharebuttons", "*", "active = '1'", array("order_by" => 'disporder, name', "order_dir" => 'ASC'));
	  
	          while($button = $db->fetch_array($query))
	          {
	               $i++;
		   
		           if($i == 1)
		           {
		              eval("\$buttons .= \"".$templates->get("misc_sharebuttons_tr_start")."\";");
			  
		     	      $trow = 2;
		           }
		   
		           if($trow == 1)
		           {
		               $trow = 2;
		           }	
		           else
		           {
		               $trow = 1;
		           }    

		           $thread_URL = $mybb->settings['bburl']."/showthread.php?tid={$thread['tid']}";
		           $thread_URL = urlencode($thread_URL);
		           $thread_subject = $thread['subject'];
			       $thread_subject = urlencode($thread_subject);
		   
		           $button['url'] = str_replace('{URL}', $thread_URL, $button['url']);
		           $button['url'] = str_replace('{TITLE}', $thread_subject, $button['url']);
		   
		           $button['link'] = $button['url'];
		           $button['popuplink'] = '';
		           $button['target'] = '_blank';
		   
                   if($button['popup'] == 1)
                   {
                       $button['popuplink'] = "MyBB.popupWindow('{$button['url']}', 'bsharethread', {$button['popupwidth']}, {$button['popupheight']});";
			           $button['link'] = $mybb->settings['bburl']."/showthread.php?tid={$thread['tid']}";
		               $button['target'] = '';
                   }		   
		   
		           eval("\$buttons .= \"".$templates->get("misc_sharebuttons_button")."\";");	
		   
		           if($i == $buttonsperrow)
		           {
			           eval("\$buttons .= \"".$templates->get("misc_sharebuttons_tr_end")."\";");
			   
		         	  $i = 0;
		              $tr = 1;
		           }	  	   
	          }
	  
	          if($i !== 0 && $tr == 1)
	          {	  
		          for ($i = $i; ; $i++)
		          {
		              if($trow == 1)
		              {
		                  $trow = 2;
		              }	
		              else
		              {
		                  $trow = 1;
		              }		  
		  
			          if($i == $buttonsperrow) 
			          {
		                  break;
		              }	
				  
			          eval("\$buttons .= \"".$templates->get("misc_sharebuttons_emptyrow")."\";");	
		          }
	          }
			  
              eval("\$sharebuttons = \"".$templates->get("misc_sharebuttons")."\";");	

              output_page($sharebuttons);			  
          }	
	}
}

function ishare_admin_action(&$action)
{
	$action['sharebuttons'] = array('active'=>'sharebuttons','file'=>'sharebuttons.php');
}

function ishare_admin_menu(&$sub_menu)
{
	global $lang; 

    $lang->load("ishare");   
	
	end($sub_menu);
	
	$key = (key($sub_menu)) + 10;
	
	$sub_menu['5'] = array
	(
		'id' => 'sharebuttons',
		'title' => $lang->sharebuttons,
		'link' => 'index.php?module=config/sharebuttons'
	);
}

function ishare_admin_groups_edit($info)
{
	global $plugins;
	
	$plugins->add_hook('admin_formcontainer_end', 'ishare_admin_groups_edit_end');
}

function ishare_admin_groups_edit_end($info)
{
	global $mybb, $lang, $form, $form_container;

	$lang->load('ishare');	
	
	if($form_container->_title == $lang->forums_posts) 
	{
		if($mybb->input['gid'] != 1)
		{		
		    $cansharethreads_options = array();
		    $cansharethreads_options[] = $form->generate_check_box('cansharethreads', 1, $lang->showsharebuttons, array('checked' => $mybb->input['cansharethreads']));
		
		    $form_container->output_row($lang->sharebuttons, '', '<div class="group_settings_bit">'.implode('</div><div class="group_settings_bit">', $cansharethreads_options).'</div>');					
	    }		
	}
}

function ishare_admin_groups_edit_commit()
{
	global $mybb, $updated_group;

	$updated_group['cansharethreads'] = intval($mybb->input['cansharethreads']);
}

function ishare_settings()
{
    global $lang;

    $lang->load("ishare");
}

?>